// DO NOT USE - THIS SHADER NEEDS TO BE UPDATED TO MATCH RIPPLE_XY.FSH AND
// INVESTIGATION IS NEEDED AS TO WHY IT BEHAVES IN THE ODD WAY IT DOES. WE
// WANT IT TO BE AS NEAR A REPLACEMENT FOR THE FRAGMENT SHADER AS POSSIBLE
// ============================================================================
// ============================================================================
// ============================================================================
// ==                                                                        ==
// == Name    : TheEmuLib.Emu_Vtx_Ripple_XY.fsh                              ==
// == Type    : Vertex shader                                                ==
// == Version : 1.0.3 (2017/01/05)                                           ==
// == Creator : TheEmu                                                       ==
// == Creator : TheEmu © TheEmu 2017, Some Rights Reserved                   ==
// == Licence : Creative Commons Attribution-ShareAlike 4.0                  ==
// ==           http://creativecommons.org/licences/by-sa/4.0                ==
// ==                                                                        ==
// == Purpose: To apply a "ripple" to vertex positions.                      ==
// ==                                                                        ==
// == Description: Vertex positions are modified by applying time dependant  ==
// == wobbling motion. The ripple at a vertex comprises a sum of up to four  ==
// == terms added to its coordinates, each term being of the form            ==
// ==                                                                        ==
// ==      A * cos ( T*F + B*y + C*x + D )                                   ==
// ==                                                                        ==
// == where T is time, (u,v) the normalised coordinates and A, B, C, D and F ==
// == are ripple parameters supplied as shader inputs.                       ==
// ==                                                                        ==
// == Static distortion may be obtained using a frequency of 0.0 for all of  ==
// == the components of the ripple.                                          ==
// ==                                                                        ==
// == This file is a member of The Emu's shader library.                     ==
// ==                                                                        ==
// == ====================================================================== ==
// ==                                                                        ==
// == Update history:                                                        ==
// ==                                                                        ==
// ==   2016/12/07 - v1.0.0 - Initial version.                               ==
// ==   2016/12/16 - v1.0.1 - Regularised format of TheEmuLib sources.       ==
// ==   2016/12/17 - v1.0.2 - Phases now in cycles for consistancy.          ==
// ==   2017/01/05 - v1.0.3 - Renamed all Wobble shaders to be Ripple.       ==
// ==                                                                        ==
// ============================================================================
// ============================================================================
// ============================================================================
// ==                                                                        ==
// == WARNING:  I do not yet fully understand some of the effects that using ==
// == this shader has on the image that it produces.  In  particular  in  my ==
// == test scenes the image is typically shifted,  and  this  shift seems to ==
// == depend on the size of the source image and the ripple parameters.  For ==
// == any particular image I can fix it up in the scene  file  but  only  by ==
// == tweaking the position or the hotspot until the image ends up  where  I ==
// == want it. There might also be some dependancy on the screen dimensions. ==
// == Until I understand this problem and fix it in the shader itself I can  ==
// == not recommend its use. TheEmu.                                         ==
// ==                                                                        ==
// ============================================================================
// ============================================================================
// ============================================================================

// ============================================================================
// == Standard shader inputs ==================================================
// ============================================================================

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// ============================================================================
// == Imports from TheEmuLib ==================================================
// ============================================================================
//
// The GLSL shader language currently provides no mechanism for importing  any
// elements that are defined in other modules, not even C's crude source level
// #include mechanism. In the absence of anything better TheEmuLib handles any
// imports by manualy copying relevent utility code snippets from the  sources
// in the Shader Lib.Inc directory. This is very crude but I have attempted to
// be systematic in the way in which this is presented in the library sources.
//
// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

// Macros from TheEmuLib.Emu_Basic_Constants.lib.src

#define PI  3.1415926535897932384626433832795
#define TAU 6.2831853071795864769252867665590

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

// Macros from TheEmuLib.Emu_Common_Utilities.lib.src

#define EMU_DEFAULT(type,x,default_value) (x==type(0.0)) ? (default_value) : (x)

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

// ============================================================================
// == Shader specific inputs ==================================================
// ============================================================================

// The vertex position may be optionaly scaled and offset.

uniform vec2 Emu_Vtx_Ripple_XY_scale;  // Defaults to (1.0,1.0)
uniform vec2 Emu_Vtx_Ripple_XY_offset; // Defaults to (0.0,0.0)

vec2 scale  = EMU_DEFAULT ( vec2, Emu_Vtx_Ripple_XY_scale,  vec2(1.0) );
vec2 offset = EMU_DEFAULT ( vec2, Emu_Vtx_Ripple_XY_offset, vec2(0.0) );

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// The ripple parameters.  Any parameter is not specified defaults to zero.
// The spatial frequency terms are the number of ripples per unit distance.

uniform vec4 Emu_Vtx_Ripple_XY_Ax; // Amplitudes
uniform vec4 Emu_Vtx_Ripple_XY_Ay; //
uniform vec4 Emu_Vtx_Ripple_XY_Bx; // Spatial frequencies (orthogonal axis terms)
uniform vec4 Emu_Vtx_Ripple_XY_By; //
uniform vec4 Emu_Vtx_Ripple_XY_Cx; // Spatial frequencies (parallel axis terms)
uniform vec4 Emu_Vtx_Ripple_XY_Cy; //
uniform vec4 Emu_Vtx_Ripple_XY_Dx; // Phases in fractions of a cycle
uniform vec4 Emu_Vtx_Ripple_XY_Dy; //
uniform vec4 Emu_Vtx_Ripple_XY_Fx; // Frequencies in Hz
uniform vec4 Emu_Vtx_Ripple_XY_Fy; //

// Ripple parameters as used in the body of the shader.

vec4 Ax = Emu_Vtx_Ripple_XY_Ax;
vec4 Ay = Emu_Vtx_Ripple_XY_Ay;

vec4 Bx = Emu_Vtx_Ripple_XY_Bx * TAU;
vec4 By = Emu_Vtx_Ripple_XY_By * TAU;

vec4 Cx = Emu_Vtx_Ripple_XY_Cx * TAU;
vec4 Cy = Emu_Vtx_Ripple_XY_Cy * TAU;

#define Dx ( Emu_Vtx_Ripple_XY_Dx * TAU )
#define Dy ( Emu_Vtx_Ripple_XY_Dy * TAU )

#define Fx ( Emu_Vtx_Ripple_XY_Fx * TAU )
#define Fy ( Emu_Vtx_Ripple_XY_Fy * TAU )

// ============================================================================
// == The shader's major function =============================================
// ============================================================================

vec2 Emu_Vtx_Ripple_XY ( vec2 uv0 )
 {
   // Calculate the four components of the x and y ripples.

   vec4 wx = Ax * cos ( u_Elapsed*Fx + Bx*uv0.y + Cx*uv0.x + Dx );
   vec4 wy = Ay * cos ( u_Elapsed*Fy + By*uv0.x + Cy*uv0.y + Dy );

   // Return the rippled coordinates, the dot products are used as
   // a quick way to sum the individual components of wx and wy.

   return uv0 + vec2 ( dot ( vec4(1.0), wx ),
                       dot ( vec4(1.0), wy )
                     );

 }

// ============================================================================
// == The shader's main routine ===============================================
// ============================================================================

void main ( void )
 {
   // Get the coordinates of the current vertex.

   vec2 uv = gl_Vertex.xy;

   // Apply the displacement to the current vertex.

   vec4 V = vec4 ( Emu_Vtx_Ripple_XY(uv), gl_Vertex.zw );

   // Update the shader's outputs.

   gl_Position    = gl_ProjectionMatrix * gl_ModelViewMatrix * V;
   gl_TexCoord[0] = gl_MultiTexCoord0;
   gl_FrontColor  = gl_Color;

 }

// ============================================================================
